#!/bin/sh
#
# MetaCard 2.5 installation script for UNIX systems
#
echo ""
echo "MetaCard 2.5 installation"

# If can't find the stacks.tgz file, then exit the script.
if test -f stacks.tgz; then
  echo ""
else
  echo "Required file \"stacks.tgz\" was not found."
  echo "Please download the file and restart this installation script."
  exit
fi

# Find out what platform they're running...
case `uname` in
    SunOS )
	case `uname -r` in
	    4* )
		platform=sparc
		prompt="SPARC SunOS 4.X"
		berkecho=true ;;
	    * )
		case `uname -m` in
		    *86 )
			platform=solintel
			prompt="Intel Solaris" ;;
		    * )
			platform=solsparc
			prompt="SPARC Solaris" ;;
		esac
	esac ;;
    HP-UX )
	case `uname -m` in
	    9000?3* | 9000?4* )
		platform=hp9k300
		prompt="HP9K300" ;;
	    * )
		platform=hp9k700
		prompt="HP9000/700/800 HP-UX 9.X-10.X-11.X" ;;
        esac ;;
    IRIX )
	platform=iris
	prompt="IRIS Irix 5.X-6.X" ;;
    Digital* )
	platform=alpha
	prompt="IRIS Irix 5.X-6.X" ;;
    Linux )
	case `uname -m` in
	    *86 )
		platform=linux
		prompt="Linux Intel" ;;
	    * )
		platform=linuxppc
		prompt="Linux PPC" ;;
        esac 
	berkecho=true ;;
    Darwin )
        platform=darwin
	prompt="Darwin" ;;
    AIX )
	platform=rs6000
	prompt="RS/6000 AIX 3.X-4.X" ;;
    * )
	platform=odt
	prompt="SCO Open Desktop, BSD, etc." ;;
esac
echo "Current platform is: $prompt"
if $berkecho
then echo -n "Install which engine? [$platform] "
else echo "Install which engine? [$platform] \c"
fi

read newplatform

if test $newplatform; then
  platform=$newplatform
fi

if test -f $platform.tar
then :
else
  echo "Can't find file $platform.tar, exiting."
  exit
fi


dir=$HOME/mc
if $berkecho
then echo -n "Install to directory [$dir] "
else echo "Install to directory [$dir] \c"
fi
read newdir
if test $newdir; then
  dir=$newdir
fi

if test -d $dir
then :
else mkdir $dir
fi

if test -d $dir
then :
else
    echo "Can't create directory $dir, exiting."
    exit
fi

# if there is an existing mchome.mc file, rename it to mchome.mc.old 
if test -f mchome.mc; then
  echo "Found an existing mchome.mc file: renaming it to mchome.mc.old..."
  mv mchome.mc mchome.mc.old
fi
olddir=`pwd`
cd $dir
echo "Unpacking file $platform.tar..."
tar xf $olddir/$platform.tar
if ./gunzip xanim.gz
then ./gunzip mc.gz
else
  echo "Can't execute gunzip (wrong platform?)"
  rm -f gunzip mc.gz xanim.gz
  echo "Please choose the correct MetaCard engine file and restart the installation."
  exit
fi

echo "Unpacking the stacks and documentation files..."
./gunzip -c $olddir/stacks.tgz | tar xf -

echo ""
echo "MetaCard installation is complete:"
echo "  You can now cd to $dir and type .\"mc\" to run MetaCard."
echo ""
